package ru.yandex.chemodan.app.stat.log;

import ru.yandex.commune.salr.logreader.LogListener;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.monica.annotation.GroupByDefault;
import ru.yandex.misc.monica.annotation.MonicaContainer;
import ru.yandex.misc.monica.annotation.MonicaMetric;
import ru.yandex.misc.monica.core.blocks.Meter;
import ru.yandex.misc.monica.core.name.MetricGroupName;
import ru.yandex.misc.monica.core.name.MetricName;

/**
 * @author Lev Tolmachev
 * @author Dmitriy Amelin (lemeh)
 * @author vpronto
 */
public class AntiFoLogListenerManager implements MonicaContainer, LogListener {

    private static final Logger logger = LoggerFactory.getLogger(AntiFoLogListenerManager.class);

    @MonicaMetric(description = "Log lines count")
    @GroupByDefault
    private final Meter lineCount = new Meter();

    @MonicaMetric(description = "Log listener error count")
    @GroupByDefault
    private final Meter listenerErrorCount = new Meter();

    private final LogListenerProvider logListenerProvider;

    public AntiFoLogListenerManager(LogListenerProvider logListenerProvider) {
        this.logListenerProvider = logListenerProvider;
        logger.info("init AntiFoLogListenerManager with listeners = '{}'", logListenerProvider);
    }

    @Override
    public void processLogLine(String line) {
        logger.trace(line);
        lineCount.inc();
        LogListener listener = null;
        try {
            listener = logListenerProvider.resolveByLogLine(line);
            listener.processLogLine(line);
        } catch (Exception e) {
            listenerErrorCount.inc();
            logger.error("Got error from listener: {}, ignoring: {}, {}", listener, line, e);
        }
    }

    @Override
    public MetricGroupName groupName(String instanceName) {
        return new MetricGroupName(
                "kafka",
                new MetricName("kafka", instanceName),
                "Processing logs from kafka for " + instanceName);
    }

}
