package ru.yandex.chemodan.app.stat.log;

import java.util.concurrent.ThreadPoolExecutor;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;

import ru.yandex.chemodan.app.stat.DiskStatManager;
import ru.yandex.chemodan.logbroker.DiskLbConsumerContextConfiguration;
import ru.yandex.inside.logbroker.pull.consumer.LbSimpleAsyncLineListener;

/**
 * @author Lev Tolmachev
 * @author vpronto
 */
@Configuration
@Import({
        DiskLbConsumerContextConfiguration.class,
})
public class DiskStatLogReaderContextConfiguration {

    @Autowired
    @Qualifier("lbListenerExecutor")
    private ThreadPoolExecutor listenerExecutor;

    @Bean
    public DownloadStatLogListener downloadStatLogListener(DiskStatManager diskStatManager) {
        return new DownloadStatLogListener(diskStatManager, new TskvLogLineParser());
    }

    @Bean
    public ZipStatLogListener zipStatLogListener(DiskStatManager diskStatManager) {
        return new ZipStatLogListener(diskStatManager);
    }

    @Bean
    @Primary
    public AntiFoLogListenerManager antiFoLogListenerManager(
            DownloadStatLogListener downloadStatLogListener,
            ZipStatLogListener zipStatLogListener)
    {
        return new AntiFoLogListenerManager(LogListenerProvider.builder()
                .addListener(downloadStatLogListener)
                .addListener(zipStatLogListener)
                .build());
    }

    @Bean
    public LbSimpleAsyncLineListener lbConsumerListener(AntiFoLogListenerManager antiFoLogListenerManager) {
        return new LbSimpleAsyncLineListener(antiFoLogListenerManager, listenerExecutor);
    }

}
