package ru.yandex.chemodan.app.stat.log;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.mpfs.MpfsHid;
import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.misc.ip.IpAddress;

/**
 * @author Lev Tolmachev
 */
public class DownloadParameters extends BaseStatParameters {

    public final int code;
    public final Option<String> hash;
    public final Option<String> name;
    public final String rtoken;
    public final Option<IpAddress> ip;
    public final double requestTimeSeconds;
    public final boolean limited;
    public final String downloaderHost;

    public DownloadParameters(int code, Option<MpfsHid> hid, DataSize traffic, Option<String> hash, Option<String> name,
            Option<String> mediaType, String rtoken, Option<IpAddress> ip, double requestTimeSeconds, boolean limited,
            String downloaderHost)
    {
        super(hid, traffic, mediaType);
        this.code = code;
        this.hash = hash;
        this.name = name;
        this.rtoken = rtoken;
        this.ip = ip;
        this.requestTimeSeconds = requestTimeSeconds;
        this.limited = limited;
        this.downloaderHost = downloaderHost;
    }
}
