package ru.yandex.chemodan.app.stat.log;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.util.tskv.TskvUtils;
import ru.yandex.commune.salr.logreader.LogListener;
import ru.yandex.misc.lang.Validate;

/**
 * @author vpronto
 */
public class LogListenerProvider {

    private final MapF<String, LogListener> listenersMap;

    private LogListenerProvider(MapF<String, LogListener> listenersMap) {
        this.listenersMap = listenersMap;
    }

    public LogListener resolveByLogLine(String line) {
        MapF<String, String> values = TskvUtils.extractTskv(line);
        String format = values.getOrThrow("tskv_format");
        return listenersMap.getOrDefault(format, NOOP);
    }

    @Override
    public String toString() {
        return "LogListenerProvider{listeners=" + listenersMap + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    private static final LogListener NOOP = line -> {
        throw new IllegalArgumentException("Can't process: " + line);
    };

    public static class Builder {
        private final MapF<String, LogListener> listenerMap = Cf.hashMap();

        public LogListenerProvider.Builder addListener(LogListener listener) {
            ListenerTskvFormat format = listener.getClass().getAnnotation(ListenerTskvFormat.class);
            Validate.notNull(format, "wrong listener: " + listener.getClass());
            listenerMap.put(format.value(), listener);
            return this;
        }

        public LogListenerProvider build() {
            Validate.notEmpty(listenerMap, "there is no listeners");
            return new LogListenerProvider(listenerMap.unmodifiable());
        }
    }
}
