package ru.yandex.chemodan.app.stat.log;

import org.junit.Test;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.mpfs.MpfsHid;
import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.misc.io.ClassPathResourceInputStreamSource;
import ru.yandex.misc.ip.IpAddress;
import ru.yandex.misc.test.Assert;

import static ru.yandex.bolts.collection.Option.empty;
import static ru.yandex.bolts.collection.Option.of;

/**
 * @author Lev Tolmachev
 */
public class TskvLogLineParserTest {

    @Test
    public void parse() {
        ListF<String> lines = new ClassPathResourceInputStreamSource(TskvLogLineParserTest.class,
                "test_access_tskv.log.txt").readLines();

        final LogLineParser parser = new TskvLogLineParser();

        ListF<Option<DownloadParameters>> parsed = lines.map(parser::parse);

        for (int i = 0; i < 9; i++) {
            Assert.some(parsed.get(i), "" + i);
        }

        Assert.some(new DownloadParameters(400, of(new MpfsHid("d288a87f39fac3e6a43341b9a96d31b0")),
                        DataSize.fromBytes(421), of("w864jFuFi7PQ2p0KP5cyQtqZQPs7aJwkA48u8A0dd4I="),
                        of("Black Mesa SNPCs.rar"), of("music"), "41113291e634d1f2b8951eac714d6565",
                        of(IpAddress.parse("101.226.180.185")), 1.956, false, "downloader-default10m.disk.yandex.com"),
                parsed.get(0));

        Assert.some(new DownloadParameters(200, of(new MpfsHid("fb54770b2c2992266333f3960ff0ff96")),
                        DataSize.fromBytes(160),
                        of("mQRamdUc7kfqswq+IGwkqgLI9MnucKNRrN9DlTdZNt50NuT5X3HjdmQbVgYo8Y+nq/J6bpmRyOJonT3VoXnDag=="),
                        of("MVI_9604.MP4"), of("video"), "nEEHYxFeeSxW",
                        of(IpAddress.parse("141.8.159.149")), 0.230, false, "downloader-default10m.disk.yandex.com"),
                parsed.get(1));

        Assert.some(new DownloadParameters(200, empty(),
                        DataSize.fromBytes(960435704),
                        of("NOPsL0eL//hNXJu9Ria1OK4C/Q8mUKZavZ1SfqktNa+ErOdcBnnH9lLGPERII47Jq/J6bpmRyOJonT3VoXnDag=="),
                        of("Учим цифры, пишем цифры.zip"), empty(), "d4GSLeoALqOv",
                        of(IpAddress.parse("2601:480:4100:4a80:1c62:765f:ba4d:7b4e")), 779.728, false,
                        "downloader-default16h.disk.yandex.net"),
                parsed.get(2));

        Assert.none(parsed.get(9));
    }


}
