package ru.yandex.chemodan.app.stat.log;

import org.junit.Test;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.mpfs.MpfsHid;
import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.misc.io.ClassPathResourceInputStreamSource;
import ru.yandex.misc.test.Assert;

import static ru.yandex.bolts.collection.Option.of;

/**
 * @author akirakozov
 */
public class ZipLineLogListenerTest {

    @Test
    public void parseLine() throws Exception {
        ListF<String> lines = new ClassPathResourceInputStreamSource(
                TskvLogLineParserTest.class,"uploader-antifo.log.txt").readLines();

        ListF<ZipStatParameters> parsed = lines.map(ZipStatLogListener::parse);

        ZipStatParameters params = new ZipStatParameters(
                of(new MpfsHid("7b8c08ebf468f99081a60bf67f18cbd2")), of("bbbb.jpg"),
                DataSize.fromBytes(436867), of("image"), true);

        Assert.equals(params, parsed.get(0));
        Assert.sizeIs(3, parsed);
    }
}
