package ru.yandex.chemodan.app.stat.log;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.stat.DiskStatManager;
import ru.yandex.chemodan.app.stat.DownloadStatChannels;
import ru.yandex.chemodan.mpfs.MpfsHid;
import ru.yandex.chemodan.util.tskv.TskvUtils;
import ru.yandex.commune.salr.logreader.LogListener;
import ru.yandex.misc.dataSize.DataSize;

import static ru.yandex.chemodan.app.stat.storage.OneChannelStats.of;

/**
 * @author akirakozov
 */
@ListenerTskvFormat("ydisk-uploader-zip-traffic-log")
public class ZipStatLogListener implements LogListener {
    private final DiskStatManager diskStatManager;

    public ZipStatLogListener(DiskStatManager diskStatManager) {
        this.diskStatManager = diskStatManager;
    }

    public static ZipStatParameters parse(String line) {
        MapF<String, String> values = TskvUtils.extractTskv(line);
        return new ZipStatParameters(
                Option.of(new MpfsHid(values.getTs("hid"))),
                values.getO("name"),
                DataSize.fromBytes(Cf.Long.parse(values.getTs("bytes"))),
                Option.of(values.getTs("media-type")),
                Cf.Boolean.parse(values.getTs("auth")));
    }

    @Override
    public void processLogLine(String line) {
        ZipStatParameters params = parse(line);
        diskStatManager.incFileDownloadStat(
                params.hid.get(), Option.empty(), params.name, params.mediaType,
                DownloadStatChannels.SIMPLE, of(params.auth, params.traffic, 1L));
    }
}
