package ru.yandex.chemodan.app.stat.moderate;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.ServerAddress;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.commune.mongo.MongoUtils;
import ru.yandex.inside.admin.conductor.Conductor;
import ru.yandex.misc.env.EnvironmentType;
import ru.yandex.misc.ip.IpPort;
import ru.yandex.misc.lang.tsb.YandexToStringBuilder;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author tolmalev
 */
@Configuration
public class ModerationContextConfiguration {
    private static final Logger logger =
            LoggerFactory.getLogger(ModerationContextConfiguration.class);

    @Bean
    public ModerationQueueClient moderationQueueClient(
            @Qualifier("moderationMongo") MongoClient moderationMongo,
            @Value("${mpfs.mongo.moderation.db.name}") String dbName,
            @Value("${moderation.mpfs.collection.name}") String collectionName)
    {
        if (EnvironmentType.getActive() == EnvironmentType.PRESTABLE) {
            return new FakeModerationQueueClient();
        } else {
            return new ModerationQueueClientImpl(moderationMongo.getDB(dbName).getCollection(collectionName));
        }
    }

    @Bean
    public MongoClient moderationMongo(
            @Value("${mpfs.mongo.hosts}")
            String hostsStr,
            @Value("${mpfs.mongo.port}")
            IpPort port,
            @Value("${mpfs.mongo.connections.per.host}")
            int connectionsPerHost,
            @Value("${mpfs.mongo.connect.timeout.ms}")
            int connectTimeoutMs,
            @Value("${mpfs.mongo.socket.timeout.ms}")
            int socketTimeoutMs,
            @Value("${mpfs.mongo.pool.timeout.ms}")
            int poolWaitTimeoutMs,
            Conductor conductor)
    {
        ListF<ServerAddress> hostList = conductor.resolveHostsFromString(hostsStr).map(
                MongoUtils.consServerAddressF(port));

        MongoClientOptions mongoOptions = MongoClientOptions.builder()
                .connectionsPerHost(connectionsPerHost)
                .connectTimeout(connectTimeoutMs)
                .socketTimeout(socketTimeoutMs)
                .maxWaitTime(poolWaitTimeoutMs)
                .build();

        logger.info("Starting mongo client to hosts {} with options: {}", hostList,
                YandexToStringBuilder.reflectionToStringValueObject(mongoOptions));

        return new MongoClient(hostList, mongoOptions);
    }
}
