package ru.yandex.chemodan.app.stat.moderate;

import ru.yandex.bolts.function.Function;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.DefaultObject;

/**
* @author tolmalev
*/
@BenderBindAllFields
public class ModerationLink extends DefaultObject {
    public final LinkType type;
    public final String url;

    public ModerationLink(LinkType type, String url) {
        this.type = type;
        this.url = url;
    }

    public static ModerationLink parseFromMpfsScriptOutput(String line) {
        String[] parts = line.split(" ");
        LinkType type;
        if (parts[0].trim().startsWith("file_link")) {
            type = LinkType.FILE;
        } else if (parts[0].trim().startsWith("folder_link")) {
            type = LinkType.FOLDER;
        } else {
            throw new IllegalArgumentException("Can't parse type: " + parts[0]);
        }
        return new ModerationLink(type, parts[1].trim());
    }

    public static Function<String, ModerationLink> parseFromMpfsScriptOutputF() {
        return ModerationLink::parseFromMpfsScriptOutput;
    }

    public enum LinkType {
        FILE,
        FOLDER
    }
}
