package ru.yandex.chemodan.app.stat.moderate;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.test.Assert;

/**
 * @author tolmalev
 */
public class ModerationLinkTest {

    @Test
    public void parseMpfsScriptOutput() {
        ListF<ModerationLink> links = StringUtils.lines(""
                + "file_link https://yadi.sk/i/5aCoYosJaSVtM\n"
                + "file_link https://yadi.sk/i/5555aCoYosJaSVtM\n"
                + "file_link https://yadi.sk/i/55555aCoYosJaSVtM\n"
                + "folder_link_1 https://yadi.sk/d/GXTQB3jAaiTLk\n"
                + "folder_link_1 https://yadi.sk/d/FkuO0xxiXFXdY\n"
                + "folder_link_2 http://yadi.sk/d/R_2xwGlrS2CdR\n"
                + "folder_link_2 https://yadi.sk/d/kXfi7trFaWEHV"
                )
                .map(ModerationLink.parseFromMpfsScriptOutputF());

        Assert.equals(
                Cf.list(
                        new ModerationLink(ModerationLink.LinkType.FILE, "https://yadi.sk/i/5aCoYosJaSVtM"),
                        new ModerationLink(ModerationLink.LinkType.FILE, "https://yadi.sk/i/5555aCoYosJaSVtM"),
                        new ModerationLink(ModerationLink.LinkType.FILE, "https://yadi.sk/i/55555aCoYosJaSVtM"),
                        new ModerationLink(ModerationLink.LinkType.FOLDER, "https://yadi.sk/d/GXTQB3jAaiTLk"),
                        new ModerationLink(ModerationLink.LinkType.FOLDER, "https://yadi.sk/d/FkuO0xxiXFXdY"),
                        new ModerationLink(ModerationLink.LinkType.FOLDER, "http://yadi.sk/d/R_2xwGlrS2CdR"),
                        new ModerationLink(ModerationLink.LinkType.FOLDER, "https://yadi.sk/d/kXfi7trFaWEHV")
                ),
                links
        );
    }
}
