package ru.yandex.chemodan.app.stat.moderate;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import org.bson.types.Binary;

import ru.yandex.chemodan.app.stat.storage.util.MpfsHidMarshaller;
import ru.yandex.chemodan.mpfs.MpfsHid;
import ru.yandex.commune.mongo.bender.MongoBenderUtils;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactoryBuilder;
import ru.yandex.misc.bender.serialize.BenderJsonSerializer;

/**
 * @author tolmalev
 */
public class ModerationQueueClientImpl implements ModerationQueueClient {

    private final DBCollection collection;

    private static final BenderConfiguration benderConfiguration = new BenderConfiguration(
            BenderConfiguration.defaultSettings(),
            CustomMarshallerUnmarshallerFactoryBuilder.cons()
                    .add(MpfsHid.class, new MpfsHidMarshaller())
                    .build()
    );

    private static final BenderJsonSerializer<ModeratorItem> serializer =
            MongoBenderUtils.createSerializer(benderConfiguration, ModeratorItem.class);

    public ModerationQueueClientImpl(DBCollection collection) {
        this.collection = collection;
    }

    @Override
    public void addToQueue(ModeratorItem moderatorItem) {
        collection.insert(MongoBenderUtils.serialize(serializer, moderatorItem));
    }

    @Override
    public boolean containsAntipornoDetectedFile(MpfsHid hid) {
        BasicDBObject query = new BasicDBObject("source", "anti-porno").append("hid", new Binary((byte) 2, hid.data));
        return collection.find(query).hasNext();
    }
}
