package ru.yandex.chemodan.app.stat.moderate;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.mpfs.MpfsHid;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author tolmalev
 */
@BenderBindAllFields
public class ModeratorItem {
    public final Instant created;
    public final Option<MpfsHid> hid;
    public final Source source;
    public final ModerationStatus status;
    public final String description;
    public final ListF<ModerationLink> links;

    public ModeratorItem(Instant created, Option<MpfsHid> hid, Source source,
            ModerationStatus status,
            String description, ListF<ModerationLink> links)
    {
        this.created = created;
        this.hid = hid;
        this.source = source;
        this.status = status;
        this.description = description;
        this.links = links;
    }

    public ModeratorItem(Instant created, String description, ListF<ModerationLink> links,
            Source source, Option<MpfsHid> hid)
    {
        this(created, hid, source, ModerationStatus.NOT_MODERATED, description, links);
    }

    public enum Source {
        ANTI_FO,
        ANTI_PORNO
    }

    public enum ModerationStatus {
        NOT_MODERATED,
        OK,
        BAD
    }
}
