package ru.yandex.chemodan.app.stat.storage;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.commune.mongo.bender.MongoId;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Lev Tolmachev
 */
@Bendable
public class CountryMediatypeStats extends DefaultObject {
    @MongoId
    @BenderPart
    public final Instant periodStart;

    @BenderPart(name = "ms")
    public final MapF<Country, MapF<String, OneChannelStats>> stats;

    public CountryMediatypeStats(Instant periodStart, MapF<Country, MapF<String, OneChannelStats>> stats) {
        this.periodStart = periodStart;
        this.stats = stats;
    }
}
