package ru.yandex.chemodan.app.stat.storage;

import org.joda.time.Duration;
import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.app.stat.TestUtils;
import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.misc.test.Assert;

/**
 * @author Lev Tolmachev
 */
public class CountryMediatypeStatsDaoTest {

    private static CountryMediatypeStatsDao getDao() {
        return new CountryMediatypeStatsDao(TestUtils.testMongoDb().getCollection("country_summary"), Duration.standardDays(1));
    }

    @Test
    public void simple() {
        CountryMediatypeStatsDao dao = getDao();

        dao.clearPeriodStatsForTests(dao.getCurrentPeriodStart());

        OneChannelStats channelStats = new OneChannelStats(
                new ViewsAndTraffic(DataSize.fromBytes(100), 1),
                new ViewsAndTraffic(DataSize.fromBytes(104), 10)
        );

        dao.inc(Country.RUSSIA, Cf.map("video", channelStats));

        CountryMediatypeStats stats = dao.getCurrentPeriodStats();

        Assert.equals(channelStats, stats.stats.getTs(Country.RUSSIA).getTs("video"));
    }

}
