package ru.yandex.chemodan.app.stat.storage;

import javax.annotation.Nonnull;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.function.Function;
import ru.yandex.commune.mongo.bender.MongoId;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Lev Tolmachev
 */
@Bendable
public class DownloadStat extends DefaultObject {
    @MongoId
    @BenderPart(name = "hid") //for backward compatibility
    private final DownloadStatId id;

    @BenderPart(name = "cs")
    private MapF<String, OneChannelStats> channelStats = Cf.hashMap();

    public DownloadStat(@Nonnull DownloadStatId id, @Nonnull MapF<String, OneChannelStats> channelStats) {
        this.id = id;
        this.channelStats = channelStats;
    }

    @Nonnull
    public DownloadStatId getId() {
        return id;
    }

    public static Function<DownloadStat, MapF<String, OneChannelStats>> getChannelStatsF() {
        return stats -> stats.channelStats;
    }

    @Nonnull
    public MapF<String, OneChannelStats> getChannelStats() {
        return channelStats;
    }
}
