package ru.yandex.chemodan.app.stat.storage;

import com.mongodb.DB;
import org.joda.time.Duration;
import org.junit.BeforeClass;
import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.stat.TestUtils;
import ru.yandex.chemodan.test.TestHelper;
import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.misc.test.Assert;

/**
 * @author Lev Tolmachev
 */
public class DownloadStatDaoTest {

    @BeforeClass
    public static void prepareLogger() {
        TestHelper.initialize();
    }

    private DownloadStatDao getDao() {
        DB db = TestUtils.testMongoDb();

        return new DownloadStatDao(db, Duration.standardHours(1));
    }

    @Test
    public void simple() {
        DownloadStatDao dao = getDao();

        DownloadStatId id = new DownloadStatId("6ab7684b26c1cdcf4e556d5237530ec3");

        Option<DownloadStat> stats = dao.getDownloadStats(id);
        DownloadStat stats2 = dao.incStats(id,
                "video", OneChannelStats.of(false, DataSize.fromMegaBytes(100), 10));

        Assert.equals(
                stats.map(DownloadStat.getChannelStatsF()).getOrElse(Cf::hashMap).
                        getOrElse("video", OneChannelStats.EMPTY).getPublicStats().getViews() + 10,
                stats2.getChannelStats().getTs("video").getPublicStats().getViews());
        Assert.equals(DownloadStatType.HASH, stats2.getId().getType());
    }
}
