package ru.yandex.chemodan.app.stat.storage;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Lev Tolmachev
 */
@Bendable
public class OneChannelStats extends DefaultObject {
    public static final OneChannelStats EMPTY = new OneChannelStats(ViewsAndTraffic.EMPTY, ViewsAndTraffic.EMPTY);

    @BenderPart(name = "a")
    private final Option<ViewsAndTraffic> authStats;
    @BenderPart(name = "p")
    private final Option<ViewsAndTraffic> publicStats;

    public OneChannelStats(ViewsAndTraffic authStats, ViewsAndTraffic publicStats) {
        this.authStats = Option.of(authStats);
        this.publicStats = Option.of(publicStats);
    }

    public ViewsAndTraffic getAuthStats() {
        return authStats.getOrElse(ViewsAndTraffic.EMPTY);
    }

    public ViewsAndTraffic getPublicStats() {
        return publicStats.getOrElse(ViewsAndTraffic.EMPTY);
    }

    public DataSize getTraffic() {
        return getAuthStats().getTraffic().plus(getPublicStats().getTraffic());
    }

    public long getViews() {
        return getAuthStats().getViews() + getPublicStats().getViews();
    }

    public OneChannelStats plus(OneChannelStats other) {
        return new OneChannelStats(
                getAuthStats().plus(other.getAuthStats()),
                getPublicStats().plus(other.getPublicStats())
        );
    }

    public static OneChannelStats of(boolean auth, DataSize traffic, long viewsCount){
        return new OneChannelStats(
                new ViewsAndTraffic(auth ? traffic : DataSize.ZERO, auth ? viewsCount : 0),
                new ViewsAndTraffic(!auth ? traffic : DataSize.ZERO, !auth ? viewsCount : 0)
        );
    }
}
