package ru.yandex.chemodan.app.stat.storage;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.function.Function;
import ru.yandex.commune.mongo.bender.MongoId;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Lev Tolmachev
 */
@Bendable
public class PeriodStats extends DefaultObject {
    @MongoId
    @BenderPart
    public final Instant periodStart;

    @BenderPart(name = "cs")
    public final MapF<String, OneChannelStats> channelStats;

    public PeriodStats(Instant periodStart, MapF<String, OneChannelStats> channelStats) {
        this.periodStart = periodStart;
        this.channelStats = channelStats;
    }

    public static Function<PeriodStats, MapF<String, OneChannelStats>> getChannelStatsF() {
        return stats -> stats.channelStats;
    }
}
