package ru.yandex.chemodan.app.stat.storage;

import org.joda.time.Duration;
import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.stat.TestUtils;
import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.misc.test.Assert;

/**
 * @author Lev Tolmachev
 */
public class PeriodSummaryStatsDaoTest {

    private static PeriodSummaryStatsDao getDao() {
        return new PeriodSummaryStatsDao(TestUtils.testMongoDb().getCollection("summary"), Duration.standardDays(1));
    }

    @Test
    public void simple() {
        PeriodSummaryStatsDao dao = getDao();

        dao.clearPeriodStatsForTests(dao.getCurrentPeriodStart());

        Assert.equals(
                new PeriodStats(dao.getCurrentPeriodStart(), Cf.map()),
                dao.getCurrentPeriodStats());

        MapF<String, OneChannelStats> map = Cf.map(
                "ch1", new OneChannelStats(
                    new ViewsAndTraffic(DataSize.fromBytes(100), 1),
                    new ViewsAndTraffic(DataSize.fromBytes(104), 10)
                ), "ch2", new OneChannelStats(
                    new ViewsAndTraffic(DataSize.fromBytes(1050), 540),
                    new ViewsAndTraffic(DataSize.fromBytes(404), 18
                )
        ));

        dao.inc(map);

        Assert.equals(
                new PeriodStats(dao.getCurrentPeriodStart(), map),
                dao.getCurrentPeriodStats());
    }
}
