package ru.yandex.chemodan.app.stat.storage;

import org.joda.time.Duration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.worker.spring.DelayingWorkerServiceBeanSupport;

/**
 * @author Lev Tolmachev
 */
public class SpooledCountryMediatypeStatsWriter extends DelayingWorkerServiceBeanSupport {
    private static final Logger logger = LoggerFactory.getLogger(SpooledCountryMediatypeStatsWriter.class);

    private final CountryMediatypeStatsDao dao;
    private MapF<Country, MapF<String, OneChannelStats>> stats = Cf.hashMap();

    private final Object lock = new Object();

    public SpooledCountryMediatypeStatsWriter(CountryMediatypeStatsDao dao) {
        this.dao = dao;
        setDelay(Duration.standardMinutes(1));
    }

    public void inc(String mediaType, OneChannelStats statsDelta) {
        synchronized (lock) {
            Country country = Country.ALL;
            MapF<String, OneChannelStats> countryStats = this.stats.getOrElseUpdate(country,
                    Cf.newHashMapF());

            OneChannelStats channelStats = countryStats.getOrElseUpdate(mediaType, OneChannelStats.EMPTY);
            channelStats = channelStats.plus(statsDelta);

            countryStats.put(mediaType, channelStats);

            logger.info("Added channelStats to spool. country: {}, mediaType: {}, channelStats: {}",
                    country, mediaType, countryStats);
        }
    }

    @Override
    protected void execute() throws Exception {
        MapF<Country, MapF<String, OneChannelStats>> currentStats;
        synchronized (lock) {
            currentStats = stats;
            stats = Cf.hashMap();
        }
        for (Tuple2<Country, MapF<String, OneChannelStats>> tuple2 : currentStats.entries()) {
            dao.inc(tuple2._1, tuple2._2);
        }
    }
}
