package ru.yandex.chemodan.app.stat.storage;

import org.joda.time.Duration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.worker.spring.DelayingWorkerServiceBeanSupport;

/**
 * @author Lev Tolmachev
 */
public class SpooledPeriodStatsWriter extends DelayingWorkerServiceBeanSupport {
    private static final Logger logger = LoggerFactory.getLogger(SpooledPeriodStatsWriter.class);

    private final PeriodSummaryStatsDao dao;
    private MapF<String, OneChannelStats> stats = Cf.hashMap();

    private final Object lock = new Object();

    public SpooledPeriodStatsWriter(PeriodSummaryStatsDao dao) {
        this.dao = dao;
        setDelay(Duration.standardMinutes(1));
    }

    public void inc(String channel, OneChannelStats statsDelta) {
        synchronized (lock) {
            OneChannelStats stats = this.stats.getOrElseUpdate(channel, OneChannelStats.EMPTY).plus(statsDelta);
            this.stats.put(channel, stats);

            logger.info("Added stats to spool. channel: {}, delta: {}", channel, statsDelta);
        }
    }

    @Override
    protected void execute() throws Exception {
        MapF<String, OneChannelStats> currentStats;
        synchronized (lock) {
            currentStats = stats;
            stats = Cf.hashMap();
        }
        if (currentStats.isNotEmpty()) {
            dao.inc(currentStats);
        }
    }
}
