package ru.yandex.chemodan.app.stat.storage;

import com.mongodb.MongoClient;
import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author Lev Tolmachev
 */
@Configuration
public class StatStorageContextConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(StatStorageContextConfiguration.class);

    @Bean
    public DownloadStatDao downloadStatsDao(
            @Qualifier("statMongoClient")
            MongoClient statMongoClient,
            @Value("${mongo.stat.db.name}")
            String dbName,
            @Value("${download-stat.aggregation.period}")
            Duration period)
    {
        return new DownloadStatDao(statMongoClient.getDB(dbName), period);
    }

    @Bean
    public PeriodSummaryStatsDao periodSummaryStatsDao(
            @Qualifier("statMongoClient")
            MongoClient statMongoClient,
            @Value("${mongo.stat.db.name}")
            String dbName,
            @Value("${download-stat.aggregation.period}")
            Duration period)
    {
        return new PeriodSummaryStatsDao(statMongoClient.getDB(dbName).getCollection("summary"), period);
    }

    @Bean
    public SpooledPeriodStatsWriter spooledPeriodStatsWriter(PeriodSummaryStatsDao dao) {
        return new SpooledPeriodStatsWriter(dao);
    }

    @Bean
    public CountryMediatypeStatsDao countryMediatypeStatsDao(
            @Qualifier("statMongoClient")
            MongoClient statMongoClient,
            @Value("${mongo.stat.db.name}")
            String dbName,
            @Value("${download-stat.aggregation.period}")
            Duration period)
    {
        return new CountryMediatypeStatsDao(statMongoClient.getDB(dbName).getCollection("country_summary"), period);
    }

    @Bean
    public SpooledCountryMediatypeStatsWriter spooledCountryMediatypeStatsWriter(CountryMediatypeStatsDao dao) {
        return new SpooledCountryMediatypeStatsWriter(dao);
    }
}
