package ru.yandex.chemodan.app.stat.storage;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Lev Tolmachev
 */
@Bendable
public class ViewsAndTraffic extends DefaultObject {
    public static final ViewsAndTraffic EMPTY = new ViewsAndTraffic(DataSize.ZERO, 0);

    @BenderPart(name = "t")
    private final Option<DataSize> traffic;
    @BenderPart(name = "c")
    private final Option<Long> views;

    public ViewsAndTraffic(DataSize traffic, long views) {
        this.traffic = Option.of(traffic);
        this.views = Option.of(views);
    }

    public DataSize getTraffic() {
        return traffic.getOrElse(DataSize.ZERO);
    }

    public long getViews() {
        return views.getOrElse(0L);
    }

    public static Function<ViewsAndTraffic, DataSize> getTrafficF() {
        return ViewsAndTraffic::getTraffic;
    }

    public static Function<ViewsAndTraffic, Long> getViewsF() {
        return ViewsAndTraffic::getViews;
    }

    public ViewsAndTraffic plus(ViewsAndTraffic other) {
        return new ViewsAndTraffic(getTraffic().plus(other.getTraffic()), getViews() + other.getViews());
    }
}
