package ru.yandex.chemodan.app.stat.storage.util;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.MongoClient;
import org.bson.types.Binary;

import ru.yandex.chemodan.app.stat.TimeUtils;
import ru.yandex.chemodan.app.stat.storage.DownloadStatId;
import ru.yandex.misc.lang.Validate;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.time.InstantInterval;

import static org.bson.BsonBinarySubType.OLD_BINARY;

/**
 * @author Lev Tolmachev
 */
public class DbUtils {
    private static final Logger logger = LoggerFactory.getLogger(DbUtils.class);

    public static DBCollection getCollection(DB db, InstantInterval interval, String prefix) {
        Validate.isTrue(interval.getStart().getMillis() % (60 * 1000) == 0);
        Validate.isTrue(interval.getEnd().getMillis() % (60 * 1000) == 0);

        return db.getCollection(prefix + "_" + TimeUtils.intervalToString(interval));
    }

    public static void shardCollection(MongoClient mongoClient, String dbName, String collectionName) {
        BasicDBObject command = new BasicDBObject("shardCollection", dbName + "." + collectionName);
        command.append("key", new BasicDBObject("_id", 1));
        mongoClient.getDB("admin").command(command);
    }

    public static BasicDBObject getIdQuery(DownloadStatId statId) {
        return new BasicDBObject("_id", new Binary(OLD_BINARY, statId.toMongoId()));
    }
}
