package ru.yandex.chemodan.app.stat.storage.util;

import java.nio.charset.StandardCharsets;

import org.bson.BsonBinarySubType;
import org.bson.types.Binary;

import ru.yandex.chemodan.app.stat.storage.DownloadStatId;
import ru.yandex.commune.json.bender.JsonValueMarshaller;
import ru.yandex.commune.mongo.bender.MongoObjectWriter;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;
import ru.yandex.misc.bender.serialize.MarshallerContext;

public class DownloadStatIdMarshaller extends JsonValueMarshaller {
    @Override
    public void writeJsonToField(BenderJsonWriter wr, Object obj, MarshallerContext ctx) {
        DownloadStatId id = (DownloadStatId) obj;
        if (wr instanceof MongoObjectWriter) {
            MongoObjectWriter w = (MongoObjectWriter) wr;
            w.writeByteArray(new Binary(BsonBinarySubType.OLD_BINARY, id.toMongoId()));
        } else {
            wr.writeString(new String(id.toMongoId(), StandardCharsets.UTF_8));
        }
    }
}

