package ru.yandex.chemodan.app.stat.storage.util;

import java.nio.charset.StandardCharsets;

import org.w3c.dom.Node;

import ru.yandex.chemodan.app.stat.storage.DownloadStatId;
import ru.yandex.commune.mongo.bender.MongoObjectNode;
import ru.yandex.misc.bender.parse.BenderJsonNode;
import ru.yandex.misc.bender.parse.FieldLevelUnmarshaller;
import ru.yandex.misc.bender.parse.ParseResult;
import ru.yandex.misc.bender.parse.UnmarshallerContext;

public class DownloadStatIdUnmarshaller implements FieldLevelUnmarshaller {
    @Override
    public ParseResult<Object> parseXmlNode(Node node, UnmarshallerContext unmarshallerContext) {
        throw new RuntimeException("xml not supported");
    }

    @Override
    public ParseResult<Object> parseJsonNode(BenderJsonNode json, UnmarshallerContext unmarshallerContext) {
        if (json.isNull()) {
            return ParseResult.result(null);
        }

        if (json instanceof MongoObjectNode) {
            MongoObjectNode mongo = (MongoObjectNode) json;
            byte[] bytes = mongo.isByteArray() ? mongo.getByteArrayValue() : mongo.getBinaryValue().getData();
            return ParseResult.result(DownloadStatId.fromMongoId(bytes));
        } else {
            return ParseResult.result(DownloadStatId.fromMongoId(
                    json.getValueAsString().getBytes(StandardCharsets.UTF_8)));
        }
    }
}
