package ru.yandex.chemodan.app.stat.storage.util;

import org.bson.types.Binary;

import ru.yandex.chemodan.mpfs.MpfsHid;
import ru.yandex.commune.mongo.bender.MongoObjectWriter;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;
import ru.yandex.misc.bender.serialize.simpleType.SimpleTypeMarshallerSupport;
import ru.yandex.misc.codec.FastBase64Coder;

/**
 * @author Lev Tolmachev
 */
public class MpfsHidMarshaller extends SimpleTypeMarshallerSupport {
    @Override
    protected String toStringValueForXml(Object o) {
        throw new IllegalStateException("XML is not supported");
    }

    @Override
    protected void writeJson(BenderJsonWriter json, Object o) {
        MpfsHid hid = (MpfsHid) o;
        if (json instanceof MongoObjectWriter) {
            MongoObjectWriter w = (MongoObjectWriter) json;
            w.writeByteArray(new Binary((byte) 2, hid.data));
        } else {
            json.writeString(new String(FastBase64Coder.encode(hid.data)));
        }
    }
}
