package ru.yandex.chemodan.app.stat.storage.util;

import org.w3c.dom.Node;

import ru.yandex.chemodan.mpfs.MpfsHid;
import ru.yandex.commune.mongo.bender.MongoObjectNode;
import ru.yandex.misc.bender.parse.BenderJsonNode;
import ru.yandex.misc.bender.parse.FieldLevelUnmarshaller;
import ru.yandex.misc.bender.parse.ParseResult;
import ru.yandex.misc.bender.parse.UnmarshallerContext;
import ru.yandex.misc.codec.FastBase64Coder;

/**
 * @author Lev Tolmachev
 */
public class MpfsHidUnmarshaller implements FieldLevelUnmarshaller {
    @Override
    public ParseResult<Object> parseXmlNode(Node node, UnmarshallerContext unmarshallerContext) {
        throw new RuntimeException("xml not supported");
    }

    @Override
    public ParseResult<Object> parseJsonNode(BenderJsonNode json, UnmarshallerContext unmarshallerContext) {
        if (json.isNull()) {
            return ParseResult.result(null);
        }

        if (json instanceof MongoObjectNode) {
            MongoObjectNode mongo = (MongoObjectNode) json;
            if (mongo.isByteArray()) {
                return ParseResult.result(new MpfsHid(mongo.getByteArrayValue()));
            } else {
                return ParseResult.result(new MpfsHid(mongo.getBinaryValue().getData()));
            }
        } else {
            return ParseResult.result(new MpfsHid(FastBase64Coder.decode(json.getValueAsString())));
        }
    }
}
