package ru.yandex.chemodan.app.stat.web;

import ru.yandex.chemodan.app.stat.limits.LimitedDownloadsDao;
import ru.yandex.chemodan.app.stat.limits.block.BlockedDownloadsDao;
import ru.yandex.chemodan.app.stat.limits.whitelist.WhitelistRegistry;
import ru.yandex.chemodan.app.stat.storage.DownloadStatId;
import ru.yandex.chemodan.mpfs.MpfsHid;
import ru.yandex.chemodan.util.web.OkPojo;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.a3.action.support.PublicCloneableActionSupport;

/**
 * @author tolmalev
 */
@Path("/add-to-whitelist")
public class AddToWhitelistAction extends PublicCloneableActionSupport {

    @RequestParam(customConverter = ConvertToMpfsHid.class)
    private MpfsHid hid;
    @RequestParam
    private String description;

    private final WhitelistRegistry whitelistRegistry;
    private final BlockedDownloadsDao blockedDownloadsDao;
    private final LimitedDownloadsDao limitedDownloadsDao;

    public AddToWhitelistAction(WhitelistRegistry whitelistRegistry,
                                BlockedDownloadsDao blockedDownloadsDao, LimitedDownloadsDao limitedDownloadsDao)
    {
        this.whitelistRegistry = whitelistRegistry;
        this.blockedDownloadsDao = blockedDownloadsDao;
        this.limitedDownloadsDao = limitedDownloadsDao;
    }

    @Override
    public Object execute() throws Exception {
        DownloadStatId id = new DownloadStatId(hid);
        blockedDownloadsDao.unblockAll(id);
        limitedDownloadsDao.clearLimited(id);
        whitelistRegistry.addToWhiteList(id, description);
        return new OkPojo();
    }
}
