package ru.yandex.chemodan.app.stat.web;

import org.joda.time.Instant;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.stat.DiskStatManager;
import ru.yandex.chemodan.app.stat.limits.LimitedDownloadsDao;
import ru.yandex.chemodan.app.stat.limits.LimitsManager;
import ru.yandex.chemodan.app.stat.limits.block.BlockDownloadsManager;
import ru.yandex.chemodan.app.stat.limits.block.BlockedDownloadsDao;
import ru.yandex.chemodan.app.stat.limits.whitelist.WhitelistRegistry;
import ru.yandex.chemodan.app.stat.storage.DownloadStatId;
import ru.yandex.chemodan.app.stat.storage.util.DownloadStatIdMarshaller;
import ru.yandex.chemodan.app.stat.storage.util.DownloadStatIdUnmarshaller;
import ru.yandex.commune.a3.ActionApp;
import ru.yandex.commune.a3.action.A3DefaultContextConfiguration;
import ru.yandex.commune.a3.action.http.ActionInvocationServlet;
import ru.yandex.commune.a3.action.result.ApplicationInfo;
import ru.yandex.commune.a3.action.result.ApplicationResultType;
import ru.yandex.commune.a3.action.result.pojo.JsonPojoResultSerializer;
import ru.yandex.commune.a3.action.result.type.MediaType;
import ru.yandex.inside.admin.conductor.GroupOrHost;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.bender.config.BenderSettings;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactoryBuilder;
import ru.yandex.misc.bender.custom.InstantAsMillisMarshaller;
import ru.yandex.misc.bender.custom.InstantAsMillisUnmarshaller;
import ru.yandex.misc.version.AppName;
import ru.yandex.misc.version.Version;
import ru.yandex.misc.web.servletContainer.SingleWarJetty;

/**
 * @author Lev Tolmachev
 */
@Configuration
@Import({
        A3DefaultContextConfiguration.class,
})
public class DiskStatWebContextConfiguration {
    @Bean
    public GroupOrHost kafkaReceivers(@Value("${conductor.workers.group}") GroupOrHost receivers) {
        return receivers;
    }

    @Bean
    public ApplicationResultType resultType() {
        return new ApplicationResultType(MediaType.APPLICATION_JSON);
    }

    @Bean
    public IncDownloadStatAction incDownloadStatAction(DiskStatManager diskStatManager) {
        return new IncDownloadStatAction(diskStatManager);
    }

    @Bean
    public ApplicationInfo applicationInfo(AppName appName, Version version) {
        return new ApplicationInfo(appName.serviceName(), version.getProjectVersion());
    }

    @Bean
    public BenderMapper a3BenderMapper() {
        return new BenderMapper(new BenderConfiguration(new BenderSettings(),
                CustomMarshallerUnmarshallerFactoryBuilder
                        .cons()
                        .add(Instant.class, new InstantAsMillisMarshaller(), new InstantAsMillisUnmarshaller())
                        .add(DownloadStatId.class, new DownloadStatIdMarshaller(), new DownloadStatIdUnmarshaller())
                        .build()));
    }

    @Bean
    public JsonPojoResultSerializer jsonPojoResultSerializer() {
        return new JsonPojoResultSerializer(a3BenderMapper());
    }

    @Bean
    public SetChannelLimitAction setChannelLimitAction(LimitsManager limitsManager) {
        return new SetChannelLimitAction(limitsManager);
    }

    @Bean
    public SetAntiPornoLimitAction setAntiPornoLimitAction(LimitsManager limitsManager) {
        return new SetAntiPornoLimitAction(limitsManager);
    }

    @Bean
    public AddToWhitelistAction addToWhitelistAction(WhitelistRegistry whitelistRegistry,
                                                     BlockedDownloadsDao blockedDownloadsDao, LimitedDownloadsDao limitedDownloadsDao)
    {
        return new AddToWhitelistAction(whitelistRegistry, blockedDownloadsDao, limitedDownloadsDao);
    }

    @Bean
    public ClearDayLimitsAction clearDayLimitsAction(BlockedDownloadsDao blockedDownloadsDao,
                                                     LimitedDownloadsDao limitedDownloadsDao)
    {
        return new ClearDayLimitsAction(blockedDownloadsDao, limitedDownloadsDao);
    }

    @Bean
    public RemoveFromWhitelistAction removeFromWhitelistAction(WhitelistRegistry whitelistRegistry) {
        return new RemoveFromWhitelistAction(whitelistRegistry);
    }

    @Bean
    public GetWhitelistAction getWhitelistAction(WhitelistRegistry whitelistRegistry) {
        return new GetWhitelistAction(whitelistRegistry);
    }

    @Bean
    public SetFileLimitAction setFileLimitAction(LimitsManager limitsManager) {
        return new SetFileLimitAction(limitsManager);
    }

    @Bean
    public GetLimitedInfoAction getLimitedInfoAction(LimitsManager limitsManager) {
        return new GetLimitedInfoAction(limitsManager);
    }

    @Bean
    public GetBlockedInfoAction getBlockedInfoAction(BlockDownloadsManager blockDownloadsManager) {
        return new GetBlockedInfoAction(blockDownloadsManager);
    }

    @Bean
    public ActionInvocationServlet actionInvocationServlet(
            @Qualifier("diskStatJetty")
            SingleWarJetty webJetty,
            ActionApp actionApp)
    {
        ActionInvocationServlet servlet =
                new ActionInvocationServlet(actionApp.getActionDispatcher(), actionApp.getResultSerializerResolver(),
                        Option.empty());
        webJetty.addServletMapping("/a3/*", servlet);
        return servlet;
    }

}
