package ru.yandex.chemodan.app.stat.web;

import ru.yandex.chemodan.app.stat.limits.block.BlockDownloadsManager;
import ru.yandex.chemodan.app.stat.limits.block.BlockInfo;
import ru.yandex.chemodan.app.stat.storage.DownloadStatId;
import ru.yandex.chemodan.mpfs.MpfsHid;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.a3.action.support.PublicCloneableActionSupport;

/**
 * @author Lev Tolmachev
 */
@Path("/get-blocked-info")
public class GetBlockedInfoAction extends PublicCloneableActionSupport {

    @RequestParam(customConverter = ConvertToMpfsHid.class)
    private MpfsHid hid;

    private final BlockDownloadsManager blockDownloadsManager;

    public GetBlockedInfoAction(BlockDownloadsManager blockDownloadsManager) {
        this.blockDownloadsManager = blockDownloadsManager;
    }

    @Override
    public BlockInfo execute() throws Exception {
        return blockDownloadsManager.getBlockInfo(new DownloadStatId(hid));
    }
}
