package ru.yandex.chemodan.app.stat.web;

import ru.yandex.chemodan.app.stat.limits.LimitedInfo;
import ru.yandex.chemodan.app.stat.limits.LimitsManager;
import ru.yandex.chemodan.app.stat.storage.DownloadStatId;
import ru.yandex.chemodan.mpfs.MpfsHid;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.a3.action.support.PublicCloneableActionSupport;

/**
 * @author Lev Tolmachev
 */
@Path("/get-limited-info")
public class GetLimitedInfoAction extends PublicCloneableActionSupport {

    @RequestParam(customConverter = ConvertToMpfsHid.class)
    private MpfsHid hid;

    private final LimitsManager limitsManager;

    public GetLimitedInfoAction(LimitsManager limitsManager) {
        this.limitsManager = limitsManager;
    }

    @Override
    public LimitedInfo execute() throws Exception {
        return limitsManager.getLimitedInfo(new DownloadStatId(hid));
    }
}
