package ru.yandex.chemodan.app.stat.web;

import ru.yandex.bolts.collection.SetF;
import ru.yandex.chemodan.app.stat.limits.whitelist.WhitelistEntry;
import ru.yandex.chemodan.app.stat.limits.whitelist.WhitelistRegistry;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.result.pojo.ActionResultPojo;
import ru.yandex.commune.a3.action.support.PublicCloneableActionSupport;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author tolmalev
 */
@Path("/get-whitelist")
public class GetWhitelistAction extends PublicCloneableActionSupport {

    private final WhitelistRegistry whitelistRegistry;

    public GetWhitelistAction(WhitelistRegistry whitelistRegistry) {
        this.whitelistRegistry = whitelistRegistry;
    }

    @Override
    public Object execute() throws Exception {
        return new Whitelist(whitelistRegistry.getWhitelist());
    }

    @ActionResultPojo
    private static final class Whitelist {
        @BenderPart
        private final SetF<WhitelistEntry> whitelist;

        public Whitelist(SetF<WhitelistEntry> whitelist) {
            this.whitelist = whitelist;
        }
    }
}
