package ru.yandex.chemodan.app.stat.web;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.stat.DiskStatManager;
import ru.yandex.chemodan.app.stat.DownloadStatChannels;
import ru.yandex.chemodan.app.stat.storage.OneChannelStats;
import ru.yandex.chemodan.mpfs.MpfsHid;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.a3.action.result.pojo.ActionResultPojo;
import ru.yandex.commune.a3.action.support.PublicCloneableActionSupport;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.dataSize.DataSize;

import static ru.yandex.chemodan.app.stat.storage.OneChannelStats.of;

/**
 * @author Lev Tolmachev
 */
@Path("/inc-download-stats")
public class IncDownloadStatAction extends PublicCloneableActionSupport {

    @RequestParam(customConverter = ConvertToMpfsHid.class)
    private MpfsHid hid;

    @RequestParam(required = false)
    private Option<String> hash = Option.empty();

    @RequestParam(required = false)
    private Option<String> name = Option.empty();

    @RequestParam(required = false)
    private String channel = DownloadStatChannels.SIMPLE;
    @RequestParam(customConverter = ConvertToDataSize.class, required = false)
    private DataSize traffic = DataSize.ZERO;
    @RequestParam(required = false)
    private long views = 1;
    @RequestParam(required = false)
    private boolean auth = false;

    @RequestParam
    private Option<String> mediatype;

    private final DiskStatManager diskStatManager;

    @Override
    public Pojo execute() throws Exception {
        return new Pojo(diskStatManager.incFileDownloadStat(hid, hash, name, mediatype, channel,
                of(auth, traffic, views)).getChannelStats());
    }

    public IncDownloadStatAction(DiskStatManager diskStatManager) {
        this.diskStatManager = diskStatManager;
    }

    @ActionResultPojo
    @BenderMembersToBind(MembersToBind.ALL_FIELDS)
    static final class Pojo {
        @BenderPart
        public final MapF<String, OneChannelStats> stats;

        Pojo(MapF<String, OneChannelStats> stats) {
            this.stats = stats;
        }
    }
}
