package ru.yandex.chemodan.app.stat.web;

import ru.yandex.chemodan.app.stat.limits.whitelist.WhitelistRegistry;
import ru.yandex.chemodan.app.stat.storage.DownloadStatId;
import ru.yandex.chemodan.mpfs.MpfsHid;
import ru.yandex.chemodan.util.web.OkPojo;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.a3.action.support.PublicCloneableActionSupport;

/**
 * @author tolmalev
 */
@Path("/remove-from-whitelist")
public class RemoveFromWhitelistAction extends PublicCloneableActionSupport {

    @RequestParam(customConverter = ConvertToMpfsHid.class)
    private MpfsHid hid;

    private final WhitelistRegistry whitelistRegistry;

    public RemoveFromWhitelistAction(WhitelistRegistry whitelistRegistry) {
        this.whitelistRegistry = whitelistRegistry;
    }

    public Object execute() throws Exception {
        whitelistRegistry.removeFromWhiteList(new DownloadStatId(hid));
        return new OkPojo();
    }
}
