package ru.yandex.chemodan.app.stat.web;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.stat.limits.LimitsManager;
import ru.yandex.chemodan.app.stat.limits.channel.ChannelLimits;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.a3.action.support.PublicCloneableActionSupport;
import ru.yandex.misc.dataSize.DataSize;

/**
 * @author metal
 */
@Path("/set-anti-porno-limit")
public class SetAntiPornoLimitAction extends PublicCloneableActionSupport {

    @RequestParam
    private String channel;
    @RequestParam
    private boolean auth;
    @RequestParam(customConverter = ConvertToDataSize.class)
    private Option<DataSize> traffic;
    @RequestParam
    private Option<Long> views;

    private final LimitsManager limitsManager;

    public SetAntiPornoLimitAction(LimitsManager limitsManager) {
        this.limitsManager = limitsManager;
    }

    @Override
    public ChannelLimits execute() throws Exception {
        return limitsManager.changeAntiPornoLimits(channel, auth, traffic, views);
    }
}
