package ru.yandex.chemodan.app.stat.worker;

import com.mongodb.MongoClient;
import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.stat.DiskStatManager;
import ru.yandex.chemodan.app.stat.admin.DiskStatAdminContextConfiguration;
import ru.yandex.chemodan.app.stat.limits.DiskLimitsContextConfiguration;
import ru.yandex.chemodan.app.stat.limits.LimitsManager;
import ru.yandex.chemodan.app.stat.limits.block.BlockDownloadsManager;
import ru.yandex.chemodan.app.stat.storage.DiskStatMongoContextConfiguration;
import ru.yandex.chemodan.app.stat.storage.DownloadStatDao;
import ru.yandex.chemodan.app.stat.storage.SpooledCountryMediatypeStatsWriter;
import ru.yandex.chemodan.app.stat.storage.SpooledPeriodStatsWriter;
import ru.yandex.chemodan.app.stat.storage.StatStorageContextConfiguration;

/**
 * @author Lev Tolmachev
 */
@Configuration
@Import({
        DiskStatMongoContextConfiguration.class,
        DiskLimitsContextConfiguration.class,
        StatStorageContextConfiguration.class,
        DiskStatAdminContextConfiguration.class
})
public class DiskStatWorkerContextConfiguration {

    @Bean
    public DiskStatManager diskStatManager(
            DownloadStatDao downloadStatDao,
            LimitsManager limitsManager,
            SpooledPeriodStatsWriter spooledPeriodStatsWriter,
            SpooledCountryMediatypeStatsWriter mediatypeStats,
            @Value("${check-limits-executor.pool-size}") int poolSize,
            @Value("${check-limits-executor.queue-capacity}") int queueCapacity)
    {
        return new DiskStatManager(downloadStatDao, limitsManager, spooledPeriodStatsWriter, mediatypeStats,
                poolSize, queueCapacity);
    }

    @Bean
    public PrepareStatCollectionTask prepareStatCollectionTask(
            @Qualifier("statMongoClient")
            MongoClient statMongoClient,
            @Value("${mongo.stat.db.name}")
            String dbName,
            @Value("${download-stat.aggregation.period}")
            Duration period)
    {
        return new PrepareStatCollectionTask(period, statMongoClient, dbName);
    }

    @Bean
    public RemoveOldCollections removeOldCollections(
            @Qualifier("statMongoClient")
            MongoClient statMongoClient,
            @Value("${mongo.stat.db.name}")
            String dbName,
            @Value("${download-stat.collections.expire.days}")
            int expireDays)
    {
        return new RemoveOldCollections(expireDays, statMongoClient.getDB(dbName));
    }

    @Bean
    public BlockLimitedFiles blockLimitedFiles(
            BlockDownloadsManager blockDownloadsManager,
            @Value("${download-stat.aggregation.period}")
            Duration period)
    {
        return new BlockLimitedFiles(period, blockDownloadsManager);
    }

    @Bean
    public LimitBlockedFilesInNextPeriod limitBlockedFilesInNextPeriod(
            BlockDownloadsManager blockDownloadsManager,
            @Value("${download-stat.aggregation.period}")
            Duration period)
    {
        return new LimitBlockedFilesInNextPeriod(period, blockDownloadsManager);
    }
}
