package ru.yandex.chemodan.app.stat.worker;

import org.joda.time.Duration;

import ru.yandex.chemodan.app.stat.limits.block.BlockDownloadsManager;
import ru.yandex.commune.bazinga.scheduler.CronTask;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.ScheduleCron;
import ru.yandex.commune.bazinga.scheduler.schedule.SchedulePeriodic;
import ru.yandex.commune.bazinga.scheduler.schedule.ScheduleWithRetry;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.time.TimeUtils;

/**
 * @author Lev Tolmachev
 */
public class LimitBlockedFilesInNextPeriod extends CronTask {
    private static final Logger logger = LoggerFactory.getLogger(LimitBlockedFilesInNextPeriod.class);

    private final Duration period;
    private final BlockDownloadsManager blockDownloadsManager;

    public LimitBlockedFilesInNextPeriod(Duration period, BlockDownloadsManager blockDownloadsManager) {
        this.period = period;
        this.blockDownloadsManager = blockDownloadsManager;
    }

    @Override
    public Schedule cronExpression() {
        if (period.isShorterThan(Duration.standardDays(1))) {
            return new SchedulePeriodic(period);
        }
        return new ScheduleWithRetry(
                new ScheduleCron("59 23 * * *", TimeUtils.EUROPE_MOSCOW_TIME_ZONE),
                50);
    }

    @Override
    public Duration timeout() {
        return Duration.standardHours(1);
    }

    @Override
    public void execute(ExecutionContext executionContext) throws Exception {
        blockDownloadsManager.limitBlockedFilesInNextPeriod();
    }
}
