package ru.yandex.chemodan.app.stat.worker;

import org.joda.time.Duration;
import org.joda.time.Minutes;

import ru.yandex.chemodan.app.stat.limits.LimitsManager;
import ru.yandex.misc.worker.spring.DelayingWorkerServiceBeanSupport;

/**
 * @author friendlyevil
 */
public class LimitMetricUpdaterWorkerService extends DelayingWorkerServiceBeanSupport {
    private final LimitsManager limitsManager;
    private final Duration period;

    public LimitMetricUpdaterWorkerService(LimitsManager limitsManager, Duration period) {
        this.limitsManager = limitsManager;
        this.period = period;
    }

    @Override
    protected void execute() throws Exception {
        limitsManager.updateNumberOfLimitedFilesToday(period);
    }

    @Override
    protected Duration defaultDelay() {
        return Minutes.minutes(20).toStandardDuration();
    }

}
