package ru.yandex.chemodan.app.stat.worker;

import java.util.concurrent.TimeUnit;

import com.mongodb.MongoClient;
import org.joda.time.Duration;

import ru.yandex.chemodan.app.stat.TimeUtils;
import ru.yandex.chemodan.app.stat.storage.DownloadStatDao;
import ru.yandex.chemodan.app.stat.storage.util.DbUtils;
import ru.yandex.commune.bazinga.scheduler.CronTask;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.SchedulePeriodic;
import ru.yandex.commune.bazinga.scheduler.schedule.ScheduleWithRetry;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.time.InstantInterval;

/**
 * @author Lev Tolmachev
 */
public class PrepareStatCollectionTask extends CronTask {
    private static final Logger logger = LoggerFactory.getLogger(PrepareStatCollectionTask.class);

    private final Duration period;
    private final MongoClient mongoClient;
    private final String dbName;

    public PrepareStatCollectionTask(Duration period, MongoClient mongoClient, String dbName) {
        this.period = period;
        this.mongoClient = mongoClient;
        this.dbName = dbName;
    }

    @Override
    public Schedule cronExpression() {
        return new ScheduleWithRetry(
                new SchedulePeriodic(period.getMillis() / 2, TimeUnit.MILLISECONDS),
                50);
    }

    @Override
    public void execute(ExecutionContext executionContext) throws Exception {
        InstantInterval currentPeriod = TimeUtils.getCurrentPeriod(period);
        InstantInterval nextPeriod = TimeUtils.getNextPeriod(currentPeriod);
        DbUtils.shardCollection(mongoClient, dbName, DownloadStatDao.getCollectionName(nextPeriod));
    }
}
