package ru.yandex.chemodan.app.stat.worker;

import com.mongodb.DB;
import org.joda.time.Duration;
import org.joda.time.Instant;

import ru.yandex.chemodan.app.stat.TimeUtils;
import ru.yandex.commune.bazinga.scheduler.CronTask;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.ScheduleCron;
import ru.yandex.commune.bazinga.scheduler.schedule.ScheduleWithRetry;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.time.InstantInterval;

/**
 * @author Lev Tolmachev
 */
public class RemoveOldCollections extends CronTask {
    private static final Logger logger = LoggerFactory.getLogger(RemoveOldCollections.class);

    private final int expireDays;
    private final DB mongoDb;

    public RemoveOldCollections(int expireDays, DB mongoDb) {
        this.expireDays = expireDays;
        this.mongoDb = mongoDb;
    }

    @Override
    public Schedule cronExpression() {
        return new ScheduleWithRetry(
                new ScheduleCron("0 4 * * *", ru.yandex.misc.time.TimeUtils.EUROPE_MOSCOW_TIME_ZONE),
                50);
    }

    @Override
    public void execute(ExecutionContext executionContext) throws Exception {
        for (String collectionName : mongoDb.getCollectionNames()) {
            try {
                if (collectionName.startsWith("download_") || collectionName.startsWith("excess_")) {
                    InstantInterval interval =
                            TimeUtils.parseInterval(StringUtils.substringAfter(collectionName, "_"));

                    if (new Duration(interval.getEnd(), Instant.now()).getStandardDays() > expireDays) {
                        mongoDb.getCollection(collectionName).drop();
                    }
                }
            } catch (RuntimeException e) {
                logger.error("Failed to process collection {}", e);
            }
        }
    }
}
