#!/bin/sh

ec() {
    echo "$@" >&2
    "$@"
}

NOARCH=noarch

ec clear
ec cd ../..

read -n 1 -p "Press ENTER to delete zaberoon files from noarch/"
ec rm -f $NOARCH/yandex-disk-downloader-*.rpm

#ec git pull --rebase
ec $YANDEX_BUILD/pkg-build/rpm/rpmchange.pl -u "Sergey Sytnik <ssytnik@yandex-team.ru>" -f yandex-disk-downloader.spec -r

ec git diff
read -n 1 -p "Press ENTER to accept current version (after fix if needed) and build package"

ec rpmbuild -bb -v yandex-disk-downloader.spec

FILES=`ls $NOARCH/yandex-disk-downloader-*.rpm`
read -n 1 -p "Found built packages: '$FILES'. Press ENTER to confirm upload and local install"

ec scp $FILES dist.mail.yandex.net:/repo/mail-rhel/6/x86_64/
ec ssh dist.mail.yandex.net "sudo createrepo --update /repo/mail-rhel/6/x86_64/"

read -n 1 -p "Press ENTER to push changelog and version update to VCS"
ec git add yandex-disk-downloader.spec
ec git commit -m "ver++"
ec git push
