#!/bin/sh

ec() {
    echo "$@" >&2
    "$@"
}

NOARCH=noarch

ec clear
ec cd ../..

read -n 1 -p "Press ENTER to delete zaberoon files from noarch/"
ec rm -f $NOARCH/yandex-disk-downloader-*.rpm

#ec svn up
#ec svn diff
read -n 1 -p "Press ENTER to build packages"

ec rpmbuild -bb -v yandex-disk-downloader.spec

FILES=`ls -1 $NOARCH/yandex-disk-downloader-*.rpm | sort -r | grep -v regional | grep -v mulca | xargs echo`
read -n 1 -p "Found built packages (except regional): '$FILES'. Press ENTER to confirm local install"

ec sudo yum remove yandex-disk-downloader yandex-disk-downloader-central
ec sudo yum install $FILES


ec sudo chown -R $(whoami) /etc/nginx/YandexDisk /etc/nginx/conf.d /etc/nginx/disk
ec perl -pi -e 's/mpfs.disk.yandex.net/mpfs1g.tst.mail.yandex.net/g' /etc/nginx/YandexDisk/DownloaderHandlers.pm;
ec perl -pi -e 's/(cache_u0:|max_size=)\d+(m|g)/${1}64m/g' /etc/nginx/conf.d/downloader.conf;
ec perl -pi -e 's/^server_name.*$/server_name downloader-local-check-auth.disk.dev.yandex.ru;/' /etc/nginx/disk/include/downloader-check-auth.include;
ec perl -pi -e 's/^server_name.*$/server_name downloader-yandex01.disk.dev.yandex.ru;/' /etc/nginx/disk/include/downloader-get-file.include;
ec perl -pi -e 's/mpfs.disk.yandex.net/mpfs1g.tst.mail.yandex.net/g' /etc/nginx/conf.d/upstreams.conf;
ec perl -pi -e 's/storage.mail.yandex.net/storagetest.mail.yandex.net/g' /etc/nginx/conf.d/upstreams.conf;
ec perl -pi -e 's/uploader.disk.yandex.net/uploader-tst.disk.yandex.net:8080/g' /etc/nginx/conf.d/upstreams.conf;
ec sudo perl -pi -e 's/mpfs.disk.yandex.net/mpfs1g.tst.mail.yandex.net/g' /etc/cron.yandex/downloads-counter-inc.pl;
ec sudo perl -pi -e 's/(cache:)\d+(m|g)/${1}64m/g' /etc/nginx/nginx.conf;
ec sudo perl -pi -e 's/(worker_connections\s*)\d+/${1}16/g' /etc/nginx/nginx.conf;
ec sudo /etc/init.d/nginx restart
