package YandexDisk;

use strict;
use warnings;

use Crypt::Rijndael;
use MIME::Base64;

use constant {
    AES_BLOCK_SIZE    => 32,
    AES_PADDING_CHAR  => '{',
};

# external

my $cipher = new Crypt::Rijndael(getStidAesSecret(), Crypt::Rijndael::MODE_ECB);

sub encrypt {
    my ($data) = @_;
    my $encrypted = $cipher->encrypt(rpad($data));
    return encode_base64($encrypted, '');
}

sub decrypt {
    my ($data) = @_;
    my $encrypted = decode_base64($data);
    return rstrip($cipher->decrypt($encrypted));
}

# internal

sub rpad {
    my ($str) = @_;
    return $str . AES_PADDING_CHAR x (AES_BLOCK_SIZE - length($str) % AES_BLOCK_SIZE);
}

sub rstrip {
    my ($str) = @_;

    my $ch = AES_PADDING_CHAR;
    $str =~ s/$ch*$//;
    return $str;
}

return 1;
