package YandexDisk;

use strict;
use warnings;

use YAML::Tiny;

my $SECRETS = loadYamlConfig(
    '/etc/yandex/disk-secret-keys.yaml',
    './t/test-disk-secret-keys.yaml',
);
my $CONF = loadYamlConfig(
    '/etc/yandex/disk-downloader.yaml',
    './t/test-downloader.yaml',
);

sub loadYamlConfig {
    return YAML::Tiny->read($_) for grep { -e $_ } @_;
    die sprintf 'Config file not found: %s', join ', ', @_;
}

sub getUrlSecret {
    return getSecret('url', '');
}

sub getStidAesSecret {
    return getSecret('stid_aes', '');
}

sub getResizerSecret {
    return getSecret('resizer', '');
}

sub getAvatarsSecret {
    return getSecret('avatars', '') || die 'avatars secret not found';
}

sub getStorageSecret {
    return getSecret('storage', '');
}


sub getSecret {
    my ($secretName, $default) = @_;

    if ($SECRETS) {
        my $value = $SECRETS->[0]->{'zaberun'}->{$secretName};
        return $value if $value;
    }
    return $default;
}

sub getAvatarsSizeLimit {
    return $CONF->[0]->{'avatars'}->{'maxSize'} || 0;
}

sub isAutowebpEnabledForSize {
    my ($size) = @_;
    return 0 unless $size;
    return scalar grep {
        my ($min, $max) = split '-', $_;
        ($size >= $min) and ($size <= $max);
    } split ',', $CONF->[0]->{'autowebp'}->{'sizes'};
}

sub isAutowebpEnabledForUid {
    my ($rule, $uid) = ($CONF->[0]->{'autowebp'}->{'uids'}, @_);
    return 1 if $rule eq 'any';
    return 0 unless $uid;
    for my $r (split ',', $rule) {
        return 1 if $r eq $uid;
        if ($r =~ /^(\d+)%$/) {
            return 1 if $1 > ($uid % 100);
        }
    }
    return 0;
}

return 1;
