package YandexDisk;

use strict;
use warnings;

use Date::Parse;


# undef or [ $reqTime, $hash, $code, $sent ]
sub parseLine {
    my ($line) = @_;

    chomp $line;
    if ($line =~ m@^\[(\d+)/(\w+)/(\d{4})\:(\d{2})\:(\d{2})\:(\d{2}).*\"GET /(disk|rdisk|rzip)/.*disposition=attachment&hash=([^&\s]+).*?HTTP/[\d\.]+\" (\d+) .* (\d+) [\d\.]+$@) {
        my ($day, $month, $year, $hour, $minute, $second,  $queryType, $hash, $code, $sent) = ($1, $2, $3, $4, $5, $6,  $7, $8, $9, $10);
        my $reqTime = str2time(sprintf('%s %s %s %s:%s:%s', $day, $month, $year, $hour, $minute, $second));
        return [$reqTime, $hash, $code, $sent];
    } else {
        return undef;
    }
}

# { $hash -> [$sent, $reqTime, $count] }
sub parseFile {
    my ($filename) = @_;
    my %parsedFile = ();

    open FH, $filename;
    while (my $line = <FH>) {
        my $parsedLine = parseLine($line);
        if (defined($parsedLine)) {
            my ($reqTime, $hash, $code, $sent) = @$parsedLine;
            
            if (200 <= $code && $code < 300) {
                my $hashInfo = $parsedFile{ $hash };
                $hashInfo = [0, undef, 0] unless defined $hashInfo;

                $hashInfo->[0] += $sent;
                $hashInfo->[1] = $reqTime;
                $hashInfo->[2] ++ unless $code == 206;

                $parsedFile{ $hash } = $hashInfo;
            }
        }
    }
    close FH;

    return \%parsedFile;
}


1;
