use strict;
use warnings;
use Test::More 'no_plan';

use lib '.'; # for local nginx.pm
use_ok('t::NginxRequestMock');
use_ok('DownloaderSecrets');
use_ok('DownloaderHandlers');
use_ok('DownloaderVars');
use_ok('DownloaderCipher');

my $r = undef;

$r = new NginxRequestMock("", "");
my %params = ("uid", "0");
is( YandexDisk::isPrivateFile($r, \%params), 0);

%params = ("uid", "123");
is( YandexDisk::isPrivateFile($r, \%params), 1);

my %headers = ("Authorization", "auth-token-123");
$r = new NginxRequestMock("", "", \%headers);
is( YandexDisk::getHeader($r, "Authorization"), "auth-token-123");

# Test: validate token calculation sha1
%params =(
    "timestamp", "100",
    "file_path", "some-path",
    "uid", "123",
    "filename", "1.txt",
    "content_type", "plain/txt",
    "disposition", "inline",
    "tknv", "v2",
    "token", "4681998b3c667fcd2a2c84ea9098ae12d99fe67f445de30eb7e2a5ab833a3eb4");
$r = new NginxRequestMock("", "");
YandexDisk::validateToken($r, \%params);

# Test: validate token calculation for endline symbols
%params =(
    "timestamp", "100",
    "file_path", "some-path",
    "uid", "123",
    "filename", "\n1.txt\n",
    "content_type", "plain/txt",
    "disposition", "inline",
    "tknv", "v2",
    "token", "3bfbb5456b68b3f37a55b114b65c7f019c5285fa698bcb4efbc133df9acc2564");
$r = new NginxRequestMock("", "");
YandexDisk::validateToken($r, \%params);

# Test: validate timestamp
%params =("timestamp", sprintf('%x', time()+10));
$r = new NginxRequestMock("", "");
YandexDisk::validateTimestamp($r, \%params);

# Test: validate unlimit timestamp version 1.0
%params =("timestamp", "mpfs");
$r = new NginxRequestMock("", "");
YandexDisk::validateTimestamp($r, \%params);

# Test: validate unlimit timestamp version 2.0
%params =("timestamp", "inf");
$r = new NginxRequestMock("", "");
YandexDisk::validateTimestamp($r, \%params);

# Tests: validate preview size
is( YandexDisk::isValidPreviewSizeParam("150x200"), 1);
is( YandexDisk::isValidPreviewSizeParam("x150"), 1);
is( YandexDisk::isValidPreviewSizeParam("150x"), 1);
is( YandexDisk::isValidPreviewSizeParam("-150x"), 0);
is( YandexDisk::isValidPreviewSizeParam("150x-150"), 0);
is( YandexDisk::isValidPreviewSizeParam("150x50x150"), 0);
is( YandexDisk::isValidPreviewSizeParam("150x5a"), 0);
is( YandexDisk::isValidPreviewSizeParam("150"), 0);
is( YandexDisk::isValidPreviewSizeParam("x"), 0);
is( YandexDisk::isValidPreviewSizeParam("XXXL"), 1);
is( YandexDisk::isValidPreviewSizeParam("XXS"), 1);
is( YandexDisk::isValidPreviewSizeParam("XL"), 1);
is( YandexDisk::isValidPreviewSizeParam("S"), 1);
is( YandexDisk::isValidPreviewSizeParam("M"), 1);
is( YandexDisk::isValidPreviewSizeParam("L"), 1);
is( YandexDisk::isValidPreviewSizeParam("XX"), 0);
is( YandexDisk::isValidPreviewSizeParam("XXXXL"), 0);
is( YandexDisk::isValidPreviewSizeParam("XM"), 0);
is( YandexDisk::isValidPreviewSizeParam("xxs"), 1);
is( YandexDisk::isValidPreviewSizeParam("xl"), 1);
is( YandexDisk::isValidPreviewSizeParam("s"), 1);
is( YandexDisk::isValidPreviewSizeParam("m"), 1);
is( YandexDisk::isValidPreviewSizeParam("l"), 1);

#Test: parse params for zip-album handler
$r = new NginxRequestMock("/zip-album/6ee2080ffa54ded706af6a66f1ef551b/555cc1c0/aHJxc3d4Q0tDcE1jaDlkTjBMMmx3am8vRWQxK3l4UktXVWhPc2loQTV1Tmd2YWhjMlM3SHo4RXVnYjZWUTNyd3EvSjZicG1SeU9Kb25UM1ZvWG5EYWc9PQ==", "");
my $params = YandexDisk::parseParams($r);
is($params->{'query_type'}, "zip-album");
is($params->{'file_path'}, "hrqswxCKCpMch9dN0L2lwjo/Ed1+yxRKWUhOsihA5uNgvahc2S7Hz8Eugb6VQ3rwq/J6bpmRyOJonT3VoXnDag==");

# Test cookie
%headers = ("Cookie", "Session_id=123-45; sessionid2=5432:123:1");
$r = new NginxRequestMock("", "", \%headers);
is(YandexDisk::getSessionIdCookie($r), "123-45");

# Test needToPatchInstaller
%headers = ("Cookie", "Session_id=123-45; sessionid2=5432:123:1");
%params =("timestamp", "inf");
$r = new NginxRequestMock("", "", \%headers);
is(YandexDisk::needToPatchInstaller($r, \%params), '');

%headers = ("Cookie", "");
%params =("al", "1");
$r = new NginxRequestMock("", "", \%headers);
is(YandexDisk::needToPatchInstaller($r, \%params), '');

%headers = ("Cookie", "Session_id=123-45; sessionid2=5432:123:1");
%params =("al", "1");
$r = new NginxRequestMock("", "", \%headers);
is(YandexDisk::needToPatchInstaller($r, \%params), 1);


#Test: parse
$r = new NginxRequestMock("", "uid=123&uid=456");
is(YandexDisk::parseGetParam($r, 'uid'), "123");

