use strict;
use warnings;
use Test::More 'no_plan';

use_ok('DownloadsCounter');

use constant {
    ACCESS_0_LOG => 't/resources/access_0.log',
};

open RESOURCE, ACCESS_0_LOG;
my @access_0 = <RESOURCE>;
close RESOURCE;

is( YandexDisk::parseLine(''), undef, 'cannot parse empty line' );
is( YandexDisk::parseLine($access_0[0]), undef, 'cannot parse valid ping line' );
isa_ok( YandexDisk::parseLine($access_0[2]), 'ARRAY', 'parsed valid rdisk line' );
isa_ok( YandexDisk::parseLine($access_0[9]), 'ARRAY', 'parsed valid disk line' );

my $parsedFile = YandexDisk::parseFile(ACCESS_0_LOG);

# /rdisk calls
my $hashInfo = $parsedFile->{'mpfs_hash2'};

is( $hashInfo->[0], 789, 'total bytes sent' );
is( $hashInfo->[2], 1, 'total noted downloads counter' );

# /disk calls
my $hashInfo2 = $parsedFile->{'mpfs_hash3'};

is( $hashInfo2->[0], 44965, 'total bytes sent' );
is( $hashInfo2->[2], 1, 'total noted downloads counter' );

