package NginxRequestMock;

use Test::More;

sub new
{
    my $class = shift;
    my $self = {
        _uri => shift,
        _args => shift,
        _headers => shift,
    };
    bless $self, $class;
    return $self;
}

sub uri {
    my( $self ) = @_;
    return $self->{_uri};
}

sub args {
    my( $self ) = @_;
    return $self->{_args};
}

sub header_in {
    my( $self, $header_name) = @_;
    return $self->{_headers}{$header_name};
}

sub log_error {
    my( $self, $code, $msg) = @_;
    diag( $msg );
}

1;
