#!/usr/bin/perl -w

use strict;
use warnings;

use constant {
    SIZE       => 10 * 1024 * 1024,
    LINE       => "Sample file line #%09d. Съешь ещё этих мягких французских булок, да выпей чаю.\n",
};

my $filename   = (@ARGV > 0 ? $ARGV[0] : './disk/html/rsample');

my $lineLength = length(sprintf(LINE, 0));
my $linesCount = SIZE / $lineLength;

print sprintf("Size = %d, line length = %d, lines count = %d, filename = %s\n", SIZE, $lineLength, $linesCount, $filename);

open SAMPLE, '>', $filename or die "Could not open $filename for writing";
for (my $i = 0; $i < $linesCount; $i++) {
    print SAMPLE sprintf(LINE, $i);
}
close SAMPLE or die "Could not close $filename";

die sprintf("Generated file size should be %d but it's %d. Check LINE.", SIZE, -s $filename) unless -s $filename == SIZE;
